;*****************************************************************************************************************
;Source File Name:
;		Wndutils.jss
;Author's Name:
;		Ben Key 
;Description:
;	JFW Script file for Wndutils.dll, the executable program for the AOL Instant Messenger buddy 
;	chat.
;Included Header Files:
;	hjconst.jsh
;		default HJ constants 
;	hjglobal.jsh
;		default HJ global variables
;	aim.jsh
;		Global header file for the entire AIM project.  Contains all constants and globals used
;		in the AIM project.
;	aim.jsm
;		Global Message file for the entire AIM project.
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 07/08/1999			Ben Key
;	Wndutils.jss added to AIM project
; 09/23/1999		Ben Key
;		Made a minor improvement to the AutoClearMessageDisplayWidowWhenTextReachesTargetRegion
;		algorithm.  The test if (strTemp != "") is no longer used to make the decision about whether or
;		not to call ClearMessageDisplayWin ().  The test that is currently implemented is 
;		If (StringLength (strTemp) > 2).  This helps to eliminate any chances for errors and 
;		speeds the process up somewhat.  Also increased the delay in scheduling the function
;		ResetnSuppressEcho to 12 from 10 to attempt to eliminate all possibility of over speakking
;		while clearing the message display window.
;		Also made considerable speed improvements to the processing that takes place in 
;		KeyPressedEvent (...) that is used to clear the message display window at the beginning 
;		of a new message if ClearDisplayWindow is equal to ACBeginMessage.
;*****************************************************************************************************************

include "hjconst.jsh"			; default HJ constants 
include "hjglobal.jsh"		; default HJ global variables
Include "AIM.jsh"
Include "AIM.jsm"

; ***/ AutoStartEvent and AutoFinishEvent functions
Void Function AutoStartEvent ()
Var
	Handle rWin, 
	Int rWinClassLen, Int FirstChildLen
Let nOrigTypeSetting = GetDefaultJCFOption (OPT_TYPING_INTERRUPT)
Let nOrigScreenSetting = GetDefaultJCFOption (OPT_SCREEN_ECHO)
Let rWin = GetRealWindow (GetFocus())
Let rWinClassLen = StringLength (GetWindowClass (rWin))
Let FirstChildLen = StringLength (GetWindowClass (GetFirstChild (rWin)))
If (rWinClassLen == iBuddyParentLen 
	&& FirstChildLen == iBuddyChildLen) then
	SwitchToScriptFile ("AIM.jsb", "") 
	Return
EndIf
If (rWinClassLen == FirstChildLen) then
	SwitchToScriptFile ("AIM.jsb", "") 
	Return
EndIf
Let numTimes = 0
If (IsMessageEditWindow () == 1) then
	SetDefaultJcfOption (OPT_TYPING_INTERRUPT, 0)
EndIf
; Change the value assigned to ClearDisplayWindow in the following line to set the default 
; option for automatically clearing the Message Display Window that you would prefer.
; Then recompile the script set to make your change take effect.  To set the option to "Auto 
; clear message display window on beginning of new message" by default, set the value of 
; ClearDisplayWindow to ACBeginMessage.  To set the option to "Auto clear message display 
; window on enter" by default, set it equal to ACOnEnter.  To set the default value to "Auto 
; clear message display window when text reaches target region," set ClearDisplayWindow 
; equal to ACTargetRegion.  To set the Auto clear message display window off by default, no 
; changes need to be made.
If (WndutilsFirstTime == 0) then
	Let ClearDisplayWindow = ACOff
	Let WndutilsFirstTime = 1
EndIf
EndFunction

Void Function AutoFinishEvent ()
SetDefaultJcfOption (OPT_TYPING_INTERRUPT, nOrigTypeSetting)
SetDefaultJcfOption (OPT_SCREEN_ECHO, nOrigScreenSetting)
EndFunction

; ***/ Functions that obtain information about the AIM environment and perform actions on the 
;	AIM environment
HANDLE Function FindMessageDisplayWindow ()
Var Handle targetParent, Handle hTarget, String rWinTitle, Handle rWin
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If (StringContains (rWinTitle, wnSegChatRoom)) then
	Let targetParent = FindDescendantWindow (rWin, cID_MessageDisplayParent)
	Let hTarget = GetFirstChild (targetParent)
	If (IsWindowVisible (hTarget) == FALSE) then 
		Return 0 
	Else
		Return hTarget
	EndIf
Else
	Return 0
EndIf
EndFunction

HANDLE Function FindMessageEditWindow ()
Var Handle targetParent, Handle hTarget, String rWinTitle, Handle rWin
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If (StringContains (rWinTitle, wnSegChatRoom)) then
	Let targetParent = FindDescendantWindow (rWin, cID_ChatEditParentA)
	Let hTarget = GetFirstChild (targetParent)
	If (IsWindowVisible (hTarget) == FALSE) then 
		Return 0 
	Else
		Return hTarget
	EndIf
Else
	Return 0
EndIf
EndFunction

Void Function ClearMessageDisplayWin ()
; old name ClearMessageDisplayWin
Var Handle hDisplayWin, Handle hChatWin, Int nOrgX, Int nOrgY
If (IsMessageEditWindow () == 1) then
	TrapKeys (TRUE)
	Let nOrgX = GetCursorCol ()
	Let nOrgY = GetCursorRow ()
	Let savedVal = GetDefaultJCFOption (OPT_SCREEN_ECHO)
	SetDefaultJcfOption (OPT_SCREEN_ECHO, 0)
	Let hDisplayWin = FindMessageDisplayWindow ()
	SaveCursor ()
	JAWSCursor ()
	MoveToWindow (hDisplayWin)
	Delay (1)
	RightMouseButton ()
	RestoreCursor ()
	Delay (1)
	{w}
	delay (1)
	{enter}
	SaveCursor ()
	JAWSCursor ()
	MoveTo (nOrgX, nOrgY)
	RoutePcToJAWS ()
	RestoreCursor ()
		If (StringLength (GetLine ()) >= 1) Then
		{Control+End}
	EndIf
	ScheduleFunction ("ResetSavedScreenEcho", 10)
	TrapKeys (FALSE)
EndIf
EndFunction

Function ClickToolBarButton (handle winHandle, string buttonLabel)
SaveCursor ()
JawsCursor ()
If (FindGraphic (winHandle, buttonLabel, s_top, s_restricted)) then
	pause ()
	LeftMouseButton ()
else
	Say(buttonLabel + msgToolNotFound, ot_control_name)
EndIf
RestoreCursor ()
EndFunction

String Function BuildAvailableButtonsList (string strExpected, int nNumMax, handle hToolBar)
Var Int nCount, String strAvailableButtonsList, String strCanidate, Int nLength
Let nCount = 1
Let strAvailableButtonsList = ""
While (nCount <= nNumMax)
	Let strCanidate = StringSegment (strExpected, "\007", nCount)
	If (FindGraphic (hToolBar, strCanidate, S_TOP, S_RESTRICTED)) then
		Let strAvailableButtonsList = strAvailableButtonsList + "\007" + strCanidate
	EndIf
	Delay (1)
	Let nCount = nCount + 1
EndWhile
Let nLength = StringLength (strAvailableButtonsList)
Let strAvailableButtonsList = StringRight (strAvailableButtonsList, nLength - 1)
Return strAvailableButtonsList
EndFunction

Handle Function GetChatToolbar ()
;	This function is used to get the window handle of the tool bar found in the chat room window.
Var Handle rWin, Handle hTarget, Handle hTemp
Let rWin = GetRealWindow (GetFocus ())
Let hTemp = FindDescendantWindow (rWin, cID_ChatEditParent)
If (hTemp) then
	Let hTarget = FindDescendantWindow (hTemp, cID_ChatToolBar)
EndIf
Return hTarget
EndFunction

Void Function ResetJCFOptions ()
SetDefaultJCFOption (OPT_SCREEN_ECHO, nOrigScreenSetting)
SetDefaultJCFOption (OPT_TYPING_ECHO, nOrigTypeSetting)
EndFunction

Void Function ResetnSuppressEcho ()
Let nSuppressEcho = FALSE
EndFunction

Int Function IsMessageEditWindow ()
;  The real window of the Chat Room window has several child windows of class 
; WndAte32Class. Both the message display window and the chat edit window are 
; child windows of a WndAte32Class window and both have a window class of Ate32Class 
; and a control ID of 0.  The message display window can be easily recognized because its 
; parent window is also the first child window of the real window and it has a control ID of 389.  
; The chat edit window can also be easily distinguished from the other windows whose class is 
; Ate32Class.  It is the only window that has as its next window a window of class CBClass that 
;	has a control ID of 980.  Its parent window also has a control ID of 390.  The relationship that 
; is used to determine whether the current window is the Chat Edit Window or the Message 
; Display Window is as follows.
;	1, 	Confirm that the window class of the current window is Ate32Class
;	2.		Confirm that the window class of the parent window is WndAte32Class.
;	3.		Find the control ID of the parent window.  
;		a.	If it is 389, then the current window is the Message Display window
;		b.	If it is 390, then the current window is the Chat Edit window
Var 
	Handle curWin, 
	Handle parentWin, 
	String curWinClass, 
	String parentWinClass, 
	Int ParentWinID
Let curWin = GetCurrentWindow ()
Let curWinClass = GetWindowClass (curWin)
Let parentWin = GetParent (curWin)
Let parentWinClass = GetWindowClass (parentWin)
Let parentWinID = GetControlID (parentWin)
If (curWinClass == wcAte32Class && parentWinClass == wcWndAte32Class) then
	If (parentWinID == cID_MessageDisplayParent) then
		Return 2
	ElIf (parentWinID == cID_ChatEditParentA) then 
		Return 1
	Else 
		Return 0
	EndIf
Else
	Return 0
EndIf	
EndFunction

Void Function ClearMessageDisplayWindowWhenTextReachesTarget ()
Var Int nDisplayHeight, Int nDisplayTop, Int nDisplayBottom, 
	Int nDisplayLeft, Int nXpos, Int nYpos, Handle hDisplay, 
	String strTemp, Int nYpos1, Int nYpos2
Let hDisplay = FindMessageDisplayWindow ()
Let nDisplayTop = GetWindowTop (hDisplay)
Let nDisplayBottom = GetWindowBottom (hDisplay)
Let nDisplayLeft = GetWindowLeft (hDisplay)
Let nDisplayHeight = nDisplayBottom - nDisplayTop
Let nXpos = nDisplayLeft + 15
Let nYpos = nDisplayBottom - (nDisplayHeight / 3)
Let nYpos1 = nYpos + (nDisplayHeight / 12)
Let nYpos2 = nYpos1 + (nDisplayHeight / 12) 
SaveCursor ()
;InvisibleCursor ()
JAWSCursor ()
MoveTo (nXpos, nYpos)
Let strTemp = GetLine ()
RestoreCursor ()
If (StringLength (strTemp) > 2) then
	Let nSuppressEcho = TRUE
	ClearMessageDisplayWin ()
	ScheduleFunction ("ResetnSuppressEcho", 12)
	Return
EndIf
SaveCursor ()
;InvisibleCursor ()
JAWSCursor ()
MoveTo (nXpos, nYpos1)
Let strTemp = GetLine ()
RestoreCursor ()
If (StringLength (strTemp) > 2) then
	Let nSuppressEcho = TRUE
	ClearMessageDisplayWin ()
	ScheduleFunction ("ResetnSuppressEcho", 12)
	Return
EndIf
SaveCursor ()
;InvisibleCursor ()
JAWSCursor ()
MoveTo (nXpos, nYpos2)
Let strTemp = GetLine ()
RestoreCursor ()
If (StringLength (strTemp) > 2) then
	Let nSuppressEcho = TRUE
	ClearMessageDisplayWin ()
	ScheduleFunction ("ResetnSuppressEcho", 12)
	Return
EndIf
EndFunction

; ***/  All other event functions and related functions
Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
Var int origSetting, Handle rWin, 
	Int rWinClassLen, Int FirstChildLen
Let rWin = GetRealWindow (GetFocus())
Let rWinClassLen = StringLength (GetWindowClass (rWin))
Let FirstChildLen = StringLength (GetWindowClass (GetFirstChild (rWin)))
If (rWinClassLen == iBuddyParentLen 
	&& FirstChildLen == iBuddyChildLen) then
	Say (GetWindowName (rWin), ot_control_name)
	Say (msgOnlineList, ot_control_name)
	SayLine ()
	SwitchToScriptFile ("AIM.jsb", "") 
	Return
EndIf
If (nSuppressEcho == TRUE) then Return EndIf
If (IsMessageEditWindow () == 1) then
	SetDefaultJcfOption (OPT_TYPING_INTERRUPT, 0)
Else
	SetDefaultJcfOption (OPT_TYPING_INTERRUPT, nOrigTypeSetting)
EndIf
FocusChangedEvent (FocusWindow, PrevWindow)
EndFunction

Void Function SayFocusedWindow ()
Var Handle rWin, String rWinTitle, Handle curWin, String curWinClass, String curWinName,
	Int curID, Int nTest, Handle hTemp
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
Let curWin = GetCurrentWindow ()
Let curWinClass = GetWindowClass (curWin)
Let curWinName = GetWindowName (curWin)
Let curID = GetCurrentControlID ()
Let nTest = IsMessageEditWindow ()
If (curWinClass == wcEdit 
	&& curID == cID_ToInvite
	&& rWinTitle == wnBuddyChatInvitation) then
	Say (wnToInvite, ot_message)
	Say (GetWindowType (GetCurrentWindow ()), ot_message)
	Return
ElIf (GetWindowClass (curWin) == wcOscarButton) then
	Say (GetWindowName (GetCurrentWindow ()), ot_message)
	Say (msgButton, ot_message)
	Return
ElIf (nTest == 1) then
	Say (wnChatRoomEdit, ot_message)
	If (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
		SayChunk ()
	EndIf
	Return
ElIf (nTest == 2) then
	Say (wnChatRoomMessageDisplay, ot_message)
	SayWindow (curWin, READ_EVERYTHING)
	Return
ElIf (curWinClass == wcOscarTree 
	&& curID == cID_WhoseHere) then
	Say (wnWhoseHere, ot_message)
	If (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
		SayChunk ()
	EndIf
	Return
EndIf
SayWindowTypeAndText (GlobalFocusWindow)
EndFunction

Void Function KeyPressedEvent (int nKey, string strKeyName, int nIsBrailleKey, int nIsScriptKey)
Var String prevKeyName, Handle ChatWin, String strTemp, Int nKeyNameLen
; Return without any further processing if the keystroke is assigned to a script.
If (nIsScriptKey) then
	Return
EndIf
; Return without any further processing if ClearDisplayWindow is not equal to ACBeginMessage (1)
If (ClearDisplayWindow != ACBeginMessage) then
	Return
EndIf
; Get the length of the key name.  This will be used to assist in deciding whether or not to call 
; ClearMessageDisplayWin ()
Let nKeyNameLen = StringLength (strKeyName)
; Do nothing if the PC Cursor is not the active cursor.
If (IsPCCursor ()) then
	;  Use the length of the key name to determine if the keystroke is used for typing or for navigation.
	;  Do nothing if the keystroke is not used for typing.
	If (nKeyNameLen == 1		;  Any letter, number, or symbol
		|| nKeyNameLen == 5	; The Space Bar
		|| nKeyNameLen == 7) Then	; Shift + Any letter, number, or symbol
		; Obtain the window handle of the Message Edit Window and copy any text it contains to a 
		; string buffer
		Let ChatWin = FindMessageEditWindow ()
		Let strTemp = GetWindowText (ChatWin, FALSE)
		;  Return without any further processing if the Message Edit Window contains any text.
		If (StringLength (strTemp) >= 1) then 
			Return
		; Otherwise if the Message Edit Window is the active window and ClearDisplayWindow is
		; equal to ACBeginMessage, then clear the message display window.
		ElIf (IsMessageEditWindow () == 1 
			&& ClearDisplayWindow == ACBeginMessage) then
			Let nSuppressEcho = TRUE
			ClearMessageDisplayWin ()
			ScheduleFunction ("ResetnSuppressEcho", 12)
			Return
		EndIf
	EndIf
EndIf
EndFunction

Void Function SayHighLightedText (handle hwnd, string buffer)
Var String rWinTitle, String hwndClass
Let rWinTitle = GetWindowName (GetRealWindow (GetFocus ()))
Let hwndClass = GetWindowClass (hwnd)
If (GlobalMenuMode != MENU_INACTIVE) then
	SayHighLightedText (hwnd, buffer)
ElIf (IsSelectItemDlg ()) then
	SayHighLightedText (hwnd, buffer)
ElIf (IsSelectScriptDlg ()) then
	SayHighLightedText (hwnd, buffer)
ElIf (GlobalMenuMode != MENU_INACTIVE) then
	SayHighLightedText (hwnd, buffer)
ElIf (hwndClass == wcSysTabControl) then
	If (numTimes == 0) then
		Say (buffer, ot_buffer)
		Let numTimes = 1
	ElIf (numTimes != 0) then
		Return
	EndIf
Else
	SayHighLightedText (hwnd, buffer)
EndIf
EndFunction

Void Function SayNonHighlightedText (handle hwnd, string buffer)
; NonHighlightedText  Function for speaking all newly written nonhighlighted
; text.
var string TheClass, Handle parentWin, String parentWinClass, Int ParentWinID
let TheClass = GetWindowClass(hwnd)
Let parentWin = GetParent (hwnd)
Let parentWinClass = GetWindowClass (parentWin)
Let parentWinID = GetControlID (parentWin)
;wcAltTab = "#32771"
if ((GetScreenEcho() > 1) 
	|| (TheClass == wcAltTab )) then 
	Say (buffer, ot_buffer) 
ElIf (theClass == wcAte32Class 
	&& parentWinClass == wcWndAte32Class
	&& parentWinID == cID_MessageDisplayParent) then
	Say (buffer, ot_buffer)
	If (ClearDisplayWindow == 3
		&& IsMessageEditWindow () == 1) then
		ScheduleFunction ("ClearMessageDisplayWindowWhenTextReachesTarget", 5)
	EndIf
EndIf
EndFunction

Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes,
int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
; Handles all newly written text.  If the text is contained in a
; frame, then the frame name is passed as a parameter
If (nSuppressEcho == TRUE) then
	Return
Else
	NewTextEvent (hwnd, buffer, nAttributes, nTextColor, nBackgroundColor, nEcho, sFrameName)
EndIf
EndFunction

; ***/  Scripts
Script ScreenSensitiveHelp ()
var Handle rWin, String rWinTitle, handle curWin, String curWinClass, String curWinName,
	Int curID,  String strTemp, Int nTest, Handle priorWin
if (IsSameScript ()) then
	AppFileTopic()
	return
EndIf
if (GlobalMenuMode > 0) then
	PerformScript ScreenSensitiveHelp()
	return
EndIf
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
Let curWin = GetCurrentWindow ()
Let curWinClass = GetWindowClass (curWin)
Let curWinName = GetWindowName (curWin)
Let curID = GetCurrentControlID ()
Let nTest = IsMessageEditWindow ()
Let priorWin = GetPriorWindow (curWin)
If (nTest == 1) then
	Say (kcmsg001 + " " + wnChatRoomEdit + " " + msgWindow, ot_help) ;"This is the"
	Say (schmsgTextInDisplay, ot_help)
	Say (schmsgWhenTextAppears, ot_help)
	Say (schmsgWhenFull, ot_help)
	Say (schmsgSeveralOptions, ot_help)
	Say (schmsgClearWinScript, ot_help)
	Say (schmsgClearWinCalledBy, ot_help)
	Say (GetScriptKeyName ("ClearMessageDisplayWindow"), ot_help)
	Say (schmsgAutoOptions, ot_help)
	Say (schmsgToggledBy, ot_help)
	Say (shmsgAccessToolBar + " " + GetScriptKeyName ("SelectATool"), ot_help)
	Say (shmsgToolBar, ot_help)
	Say (kcmsg008, ot_help) ;"Use the left and right arrow keys to move through the entered text"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
ElIf (nTest == 2) then
	Say (kcmsg001 + " " + wnChatRoomMessageDisplay, ot_help) ;"This is the"
	Say (shmsgMessageDisplay, ot_help)
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
ElIf (curWinClass == wcOscarButton) then
	Let strTemp = GetWindowName (GetCurrentWindow ())
	Say (kcmsg001, ot_help) ;"This is the"
	Say (strTemp, ot_help)
	Say (kcmsg001a, ot_help) ;"button"
	Say (kcmsg002, ot_help) ;"Use enter to activate it"
	Say (kcmsg003, ot_help) ;" Use Tab to move to the next Control"
	Return
ElIf (curWinClass == wcOscarTree 
	&& curID == cID_WhoseHere 
	&& GetWindowClass (priorWin) == wcOscarStatic) then
	Say (kcmsg001 + " " + wnWhoseHere, ot_help)
	Say (shmsgWhoseHere, ot_help)
	Say (kcmsg017, ot_help) ;"Use the arrow keys or the first letter to move to an item"
	Say (kcmsg018, ot_help) ;"Use Enter to select it"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
PerformScript ScreenSensitiveHelp()
EndScript

Script SelectATool ()
Var handle winHandle, int nItem,	String strButtonList, String strSelectedTool, Int nTest
Let nTest = IsMessageEditWindow ()
If (nTest == 0
	|| nTest == 2) then
		Say (msgChatEditOnly, ot_message)
		Return
ElIf (nTest == 1) then
	let winHandle = GetChatToolbar ()
	if (!winHandle || !IsWindowVisible (winHandle)) then
		return
	EndIf
	Let strButtonList = BuildAvailableButtonsList (strChatToolBar, NumTools, winHandle)
	let nItem = dlgSelectItemInList (strButtonList, ChatRoomToolBarDialog, FALSE)
	If (nItem !=0) then
		Let strSelectedTool = StringSegment (strButtonList, "\007", nItem)
		let nSuppressEcho = TRUE
		delay (2)
		ClickToolBarButton (winHandle, strSelectedTool)
	EndIf
	ScheduleFunction ("ResetnSuppressEcho", 2)
EndIf
EndScript

Script ClearMessageDisplayWindow ()
Let savedVal = GetDefaultJCFOption (OPT_SCREEN_ECHO)
Let nSuppressEcho = TRUE
ClearMessageDisplayWin ()
ScheduleFunction ("ResetnSuppressEcho", 10)
ScheduleFunction ("ResetSavedScreenEcho", 10)
EndScript

Script ToggleClearMessageDisplayWindowOption ()
If (ClearDisplayWindow < 3) then
	Let ClearDisplayWindow = ClearDisplayWindow + 1
	Delay (1)
	If (ClearDisplayWindow == 1) then
		Say (msgClearWindow1, ot_status)
	ElIf (ClearDisplayWindow == 2) then
		Say (msgClearWindow2, ot_status)
	ElIf (ClearDisplayWindow == 3) then
		Say (msgClearWindow3, ot_status)
	EndIf
ElIf (ClearDisplayWindow == 3) then
	Let ClearDisplayWindow = 0
	Say (msgClearWindowOff, ot_status)
EndIf
EndScript

Script ClearMessageDisplayWindowOnEnter ()
If (ClearDisplayWindow == 2
	&& IsMessageEditWindow () == 1) then
	{Enter}
	Let nSuppressEcho = TRUE
	ClearMessageDisplayWin ()
	ScheduleFunction ("ResetnSuppressEcho", 10)
Else
	{Enter}
EndIf
EndScript

Script  ScriptFileName()
ScriptAndAppNames(msgBCScriptFile) ;msgBCScriptFile = "AOL Instant messenger Buddy Chat",
EndScript


Script HotKeyHelp ()
Var Handle rWin, String rWinTitle, Handle hSend, Int nSendState	
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If (StringContains (rWinTitle, wnBuddyChatInvitation)) then
;	cID_BCISend = 418,
	Let hSend = FindDescendantWindow (rWin, cID_BCISend)
	If (IsWindowDisabled (hSend) == TRUE) then
		Let nSendState = 0
	Else
		Let nSendState = 1
	EndIf
	If (nSendState) then
		Say (hkmsgSendButton, ot_help)
	EndIf
	Say (hkmsgBCICancelButton, ot_help)
	Say (hkmsgBCIHelpButton, ot_help)
	Return
ElIf (StringContains (rWinTitle, wnSegChatRoom)) then
;	cID_BCSend = 391
	Let hSend = FindDescendantWindow (rWin, cID_BCSend)
	If (IsWindowDisabled (hSend) == TRUE) then
		Let nSendState = 0
	Else
		Let nSendState = 1
	EndIf
	If (nSendState) then
		Say (hkmsgSendButton, ot_help)
	EndIf
	Say (hkmsgInfoButton, ot_help)
	Say (hkmsgBCIMButton, ot_help)
	Say (hkmsgBCIgnoreButton, ot_help)
	Return
EndIf
PerformScript HotKeyHelp()
EndScript

Script AdjustJAWSVerbosity ()
var   	string list
if (IsSpeechOff ()) then
	PerformScript MuteSynthesizer()
	return
endif
let list = AutoClearWinItem +
	VerbosityLevelItem +
	ScreenEchoItem +
	TypingEchoItem  +
	SayAllByItem +
	PunctuationLevelItem +
	FormatItem +
	GraphicsItem +
	AnsiCharsIncItem +
	BrailleVerbosityItem +
	MuteSynth
	DlgSelectScriptToRun (list, AdjustJawsVerbosityDialogName, false)
EndScript

Script  SayWindowPromptAndText()
;SayWindowTypeAndText(GetCurrentWindow())
SayFocusedWindow ()
EndScript